class CTF_Mutator expands Mutator config(AdultSetup);

var config string 	CTFGameName,
			CTFLeftMessage,
			CTFEnteredMessage,
			RedTeamIcon,
			BlueTeamIcon;
var int Dice;

function PreBeginPlay ()
{
	Super.PreBeginPlay();
	SaveConfig();

	Level.Game.ScoreBoardType = Class'CTF_SB';
	Level.Game.HUDType = Class'CTF_HUD';
	Level.Game.GameName = CTFGameName;
	Level.Game.LeftMessage = CTFLeftMessage;
	Level.Game.EnteredMessage = CTFEnteredMessage;

	AddMutator(Level.Spawn(class'CTF_StatsMutator'));
	AddMutator(Level.Spawn(class'IP2Country'));
	AddMutator(Level.Spawn(class'AdultInventory'));
	AddMutator(Level.Spawn(class'Revenge'));
	AddMutator(Level.Spawn(class'Mapstats'));
	Dice = Rand(3);
	SetTimer(1.0,True);
}

function Timer()
{
local Pawn P;

	Super.Timer();

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			PRI(PlayerPawn(P).PlayerReplicationInfo).RedTeamIcon = RedTeamIcon;
			PRI(PlayerPawn(P).PlayerReplicationInfo).BlueTeamIcon = BlueTeamIcon;
			}
		}
}

function bool AlwaysKeep(Actor Other) 
{
	
	if (Other.IsA('PlayerPawn'))
        	{
		PlayerPawn(Other).PlayerReplicationInfoClass = class'PRI';
		return true;
		}
	if (Other.IsA('Bot'))
        	{
		Bot(Other).PlayerReplicationInfoClass = class'PRI';
		return true;
		}
	if (Other.IsA('Carcass'))
		{
		Carcass(Other).Style = STY_Translucent;
		Carcass(Other).bProjTarget = False;
		Carcass(Other).bBlockPlayers = False;
		}
	if (Other.IsA('Ammo') && !Other.IsA('WarHeadAmmo'))
		{
		Ammo(Other).AmmoAmount = Ammo(Other).default.AmmoAmount * 2;
		Ammo(Other).MaxAmmo = Ammo(Other).default.MaxAmmo * 10;
		}
	if (Other.IsA('GooGun'))
		{
		GooGun(Other).MultiSkins[1]=Texture'GooGunSkinA';
		GooGun(Other).MultiSkins[3]=Texture'GooGunSkinB';
		}
	if (Other.IsA('BukkakeGun'))
		{
		BukkakeGun(Other).MultiSkins[1]=Texture'BukkakeGunSkinA';
		BukkakeGun(Other).MultiSkins[3]=Texture'BukkakeGunSkinB';
		BukkakeGun(Other).MultiSkins[0]=Texture'BukkakeGunSkinC';
		}
	if (Other.IsA('FlagBase') )
		{

		if ( Dice == 0 )
			FlagBase(Other).MultiSkins[0]=Texture'FlagA';
		else if ( Dice == 1 )
			FlagBase(Other).MultiSkins[0]=Texture'FlagB';
		else
			FlagBase(Other).MultiSkins[0]=Texture'FlagC';

		}
	if (Other.IsA('CTFFlag') )
		{
		if ( Dice == 0 )
			CTFFlag(Other).MultiSkins[0]=Texture'FlagA';
		else if ( Dice == 1 )
			CTFFlag(Other).MultiSkins[0]=Texture'FlagB';
		else
			CTFFlag(Other).MultiSkins[0]=Texture'FlagC';
		}

	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));
	
	return false;
}

defaultproperties
{
CTFGameName="Adult Capture The Flag"
CTFLeftMessage=" is a quitter!!!"
CTFEnteredMessage=" joined the action!"
}
